% Function: This is the program calculates the Kolmogorov-Smirnov test 
% between each entry of two different cell arrays and outputs the 
% significance value (p-value) in a matrix of the same dimensions.

% Inputs:
% Cell_1/2 - cell array where each entry is a list of values, primarily a
%    list that contains reporter values for each ip/probe combination

% Outputs:
% KS_PMatrix - a matrix array with the same dimension of cell_1/2, where 
%    each entry contains the p-value from the Kolmogorov-Smirnov test

function [KS_PMatrix] = KS_P_Matrix(Cell_1, Cell_2)

% determines the size of cell 1 (note Cell_2 must be the same demensions)
[row,col] = size(Cell_1);

% initialize an empty matrix to store the difference matrices for each
% entry
KS_PMatrix = zeros(row,col);

% loop over the number of rows (probes)
parfor i=1:row
    % loop over the number of col (IPs)
    for j=1:col
        
            if isempty(Cell_1{i,j}) == 0 && isempty(Cell_2{i,j}) == 0;
                % perform a Two-sample Kolmogorov-Smirnov test to compare the 
                % kth resampling of cell 1 and cell 2
                [~,p] = kstest2(Cell_1{i,j}, Cell_2{i,j}, 0.05,...
                    'unequal');
            
                % store the p-value from the kth comparison in the list 
                % ij_PValues
                KS_PMatrix(i,j) = p;
            else
                KS_PMatrix(i,j) = NaN;
            end
            
    end
end